# BoldGrid Theme Framework #

[![Build Status](https://api.travis-ci.org/BoldGrid/boldgrid-theme-framework.svg?branch=master)](https://travis-ci.org/BoldGrid/boldgrid-theme-framework)
[![License](https://img.shields.io/badge/license-GPL--3.0%2B-orange.svg)](https://raw.githubusercontent.com/BoldGrid/boldgrid-theme-framework/master/LICENSE)
[![PHP Version](https://img.shields.io/badge/PHP-5.6%2B-blue.svg)](https://php.net)
[![Code Climate](https://codeclimate.com/github/BoldGrid/boldgrid-theme-framework/badges/gpa.svg)](https://codeclimate.com/github/BoldGrid/boldgrid-theme-framework)

* **Contributors:** rramo012, timph, jamesros161
* **Tags:** inspiration,customization,build,create,design
* **Requires at least:** 4.9
* **Tested up to:** 6.1
* **License:** GPL-3.0-or-later
* **License URI:** https://www.gnu.org/licenses/gpl-3.0-standalone.html

<a href="https://www.browserstack.com/" title="BrowserStack" target="_blank">
<img src="https://p14.zdusercontent.com/attachment/1015988/e7lZDYUQAcrjhARfSQKnVsW5M?token=eyJhbGciOiJkaXIiLCJlbmMiOiJBMTI4Q0JDLUhTMjU2In0..Rj7ZUz59GX2kLfySyw8pdw.q8aA7RoJrLrobEqyTsY8eit4vnvNQuNMuQS9-HyFoLtLu6Q8lsQmHuiboyA8w1HYC_5raUBaIpKLsj_lV5AwEX_aw2-zbSe5EXWiIEuoXHBmLKjSD657s8JMsird0qXUgYvpU9jGZPj9cZj42msR2Cb0lasANAf5ISP6I0qc0Xx2yRRkwjT_r94Z7GCyGMZhCw8pA3Da9Jz0_TZzS62wOgdoxizVMsrnw3Bj_F34eMvZIOI3uclFVVUQu-j-m8qamarikMSLQlr2hAPLjBknibGj6HGO2T8jHwVDz2cH6NU.OFY7iswivDQLRyvfVbc7yw" width="30%" height="30%" />
</a>

Browser testing and compatibility is made possible to us with <a href="https://www.browserstack.com/" title="BrowserStack" target="_blank">BrowserStack</a>'s awesome support and wonderful service! The following browsers are the currently supported browsers for BoldGrid Theme Framework. Other browsers do work perfectly fine for the frontend of websites, but aren't guaranteed to have active testing and bugfixes in terms of the tools provided to build a site.  We highly suggest using a modern browser, such as the <a href="https://www.google.com/chrome/browser/" title="Download Google Chrome" target="_blank">latest Chrome release</a>.

| [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/edge/edge_48x48.png" alt="IE / Edge" width="24px" height="24px" />](http://godban.github.io/browsers-support-badges/)</br>Edge | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/firefox/firefox_48x48.png" alt="Firefox" width="24px" height="24px" />](http://godban.github.io/browsers-support-badges/)</br>Firefox | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/chrome/chrome_48x48.png" alt="Chrome" width="24px" height="24px" />](http://godban.github.io/browsers-support-badges/)</br>Chrome | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/safari/safari_48x48.png" alt="Safari" width="24px" height="24px" />](http://godban.github.io/browsers-support-badges/)</br>Safari | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/safari-ios/safari-ios_48x48.png" alt="iOS Safari" width="24px" height="24px" />](http://godban.github.io/browsers-support-badges/)</br>iOS Safari | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/opera/opera_48x48.png" alt="Opera" width="24px" height="24px" />](http://godban.github.io/browsers-support-badges/)</br>Opera |
| --------- | --------- | --------- | --------- | --------- | --------- |
| last version | last 2 versions| last 2 versions| last 2 versions| last 2 versions| last version

## Description ##

BoldGrid Theme Framework is a library that allows you to easily make BoldGrid themes.
Please see our reference guide for more information: https://www.boldgrid.com/docs/configuration-file

## Installation ##

1. Create a configuration that overrides required fields. Please see the BoldGrid theme
user guide for more information.

1. Include boldgrid-theme-framework.php from your theme's functions.php

## Changelog ##

### 2.18.2 ###
* Bug Fix: Fixed Container CPH = 0 padding on mobile [#779](https://github.com/BoldGrid/boldgrid-theme-framework/issues/779)
* Update: Remove unnecessary woocommerce template override global/quantity-input.php

### 2.18.1 ###
* Bug Fix: Some footer designs are altered when upgrading from 2.17 to 2.18 [#774](https://github.com/BoldGrid/boldgrid-theme-framework/issues/774)
* Bug Fix: PHP 8.1 installing recommended plugins [#776](https://github.com/BoldGrid/boldgrid-theme-framework/issues/776)

### 2.18.0 ###
* New Feature: Support for Crio Premium's MegaMenus feature.

### 2.17.3 ###
* Update: Updated WooCommerce templates used by Crio [#148](https://github.com/BoldGrid/prime/issues/148)
* Update: Add additional filters to support and upsell URLs.

### 2.17.2 ###
* Bug Fix: Change metabox text color to black to pass accessibility [#755](https://github.com/BoldGrid/boldgrid-theme-framework/issues/755)
* Bug Fix: Changing Color Palette changes page content [#750](https://github.com/BoldGrid/boldgrid-theme-framework/issues/750)
* Bug Fix: (SproutPRO) Can't access PDF's with Crio enabled [#146](https://github.com/BoldGrid/prime/issues/146)
* Bug Fix: Sidebar hover effects incorrect [#741](https://github.com/BoldGrid/boldgrid-theme-framework/issues/741)

### 2.17.1 ###
* Bug Fix: (Sprout) Crio doesn't load sa_templates properly [#620](https://github.com/BoldGrid/boldgrid-theme-framework/issues/620)
* Bug Fix: btn-large not consistent between button-primary and button-secondary [#738](https://github.com/BoldGrid/boldgrid-theme-framework/issues/)
* Bug Fix: Footer links inherit site content link hover effect [#733](https://github.com/BoldGrid/boldgrid-theme-framework/issues/733)
* Bug Fix: Add Media modal uses theme fonts & colors without PPB active [#721](https://github.com/BoldGrid/boldgrid-theme-framework/issues/721)

### 2.17.0 ###
* New Feature: Allow Post featured image to link to post single page [#399](https://github.com/BoldGrid/boldgrid-theme-framework/issues/399)
* Bug Fix: Fix Build Dependancies [#734](https://github.com/BoldGrid/boldgrid-theme-framework/issues/734)

### 2.16.3 ###
* Bug Fix: Logos using Flex display stretch vertically on iOS [#516](https://github.com/BoldGrid/boldgrid-theme-framework/issues/516)
* Bug Fix: Duplicate Header in Customizer related to Windows display settings [#488](https://github.com/BoldGrid/boldgrid-theme-framework/issues/488)
* Bug Fix: WPForms email confirmation field error [#614](https://github.com/BoldGrid/boldgrid-theme-framework/issues/614)
* Bug Fix: Conflict with PolyLang, Header/Footer Layout Controls do not function [#401](https://github.com/BoldGrid/boldgrid-theme-framework/issues/401)
* Update: Update "postcss" dependancy from 6.0.22 -> 8.2.13 [#370](https://github.com/BoldGrid/boldgrid-theme-framework/pull/370)
* Update: Update "snyk " dependancy from 1.338.0 -> 1.685.0 [#562](https://github.com/BoldGrid/boldgrid-theme-framework/pull/562)
* Update: Update "@wordpress/dom-ready" dependancy from 2.11.0 -> 2.13.2 [#367](https://github.com/BoldGrid/boldgrid-theme-framework/pull/367)
* Update: Update "@wordpress/hooks" dependancy from 2.10.0 -> 2.12.2 [#366](https://github.com/BoldGrid/boldgrid-theme-framework/pull/366)
* Update: Update "@babel/runtime-corejs2" dependancy from 7.12.1 -> 7.13.17 [#365](https://github.com/BoldGrid/boldgrid-theme-framework/pull/365)
* Update: Update "moment" dependancy from 2.24.0 -> 2.29.4 [f4ddfd5](https://github.com/BoldGrid/boldgrid-theme-framework/commit/f4ddfd55dbecc26f492772aa391253374a8dff54)
* Update: Update "follow-redirects" dependacy from 1.5.9 -> 1.15.1 [399bcab](https://github.com/BoldGrid/boldgrid-theme-framework/commit/399bcab7d87c39aa138c729407b0ac322fa9af3c)
* Update: Update "url-parse" dependancy from 1.4.3 -> 1.5.10 [e9a9eee](https://github.com/BoldGrid/boldgrid-theme-framework/commit/e9a9eee394bbce774102a7e67df78ab93bc71714)
* Update: Update "chownr" dependancy from 1.0.1 -> 1.1.4 [1b1d681](https://github.com/BoldGrid/boldgrid-theme-framework/commit/1b1d681f06337e70da7bf79e04316031fcc02d69)
* Update: Update "i" dependancy from 0.3.6 -> 0.3.7 [855c5d0](https://github.com/BoldGrid/boldgrid-theme-framework/commit/855c5d0e6863759372cc027c6514957f65dec023)
* Update: Update "puppeteer" dependancy from 1.9.0 -> 1.20.0 [132f018](https://github.com/BoldGrid/boldgrid-theme-framework/commit/132f018fd79b8de7a6326dd3fa6fd991e9d91f25)

### 2.16.2 ###
* Bug Fix: Dividing by Zero in the Header [#708](https://github.com/BoldGrid/boldgrid-theme-framework/issues/708)
* Bug Fix: Featured Image background for Posts does not display [#717](https://github.com/BoldGrid/boldgrid-theme-framework/issues/717)
* Bug Fix: WooCommerce Custom Ordering is Ignored [#363](https://github.com/BoldGrid/boldgrid-theme-framework/issues/363)
* Bug Fix: Review z-index with dropdown menus [#489](https://github.com/BoldGrid/boldgrid-theme-framework/issues/489)

### 2.16.1 ###
* Bug Fix: Hover Underline Reveal effect for Menus is broken [#711](https://github.com/BoldGrid/boldgrid-theme-framework/issues/711)
* Bug Fix: Allow filtering of Premium URL's in theme [#706](https://github.com/BoldGrid/boldgrid-theme-framework/issues/706)
* Bug Fix: Fix submenu background colors not changing with palette
* Bug Fix: Hover Effect for Links does not respect Customizer setting [#713](https://github.com/BoldGrid/boldgrid-theme-framework/issues/713)

### 2.16.0 ###
* New Feature: Change translucent overlays with palette changes [#554](https://github.com/BoldGrid/boldgrid-theme-framework/issues/554)
* New Feature: Make menu underlines and menu hovers match styles [#586](https://github.com/BoldGrid/boldgrid-theme-framework/issues/586)
* New Feature: Change Menu Button styles to match padding / margins of other menu items [#546](https://github.com/BoldGrid/boldgrid-theme-framework/issues/546)
* Bug Fix: Transparent Buttons in Menus do not work as expected [#702](https://github.com/BoldGrid/boldgrid-theme-framework/issues/702)
* Bug FIx: Responsive Typography - Live Preview is incorrect with Custom Page Headers [#704](https://github.com/BoldGrid/boldgrid-theme-framework/issues/704)
* Bug Fix: MFW / FWR content has gap on left side [#701](https://github.com/BoldGrid/boldgrid-theme-framework/issues/701)
* Bug Fix: Customizer Heading font used in dashboard [#705](https://github.com/BoldGrid/boldgrid-theme-framework/issues/705)
* Bug Fix: Font weights do not update in live preview [#677](https://github.com/BoldGrid/boldgrid-theme-framework/issues/677)
* Bug Fix: Responsive typography - live preview is incorrect [#684](https://github.com/BoldGrid/boldgrid-theme-framework/issues/684)

### 2.15.0 ###
* New Feature: Add font-display: swap to FontAwesome CSS [#649](https://github.com/BoldGrid/boldgrid-theme-framework/issues/649)
* New Feature: Improve integration with weForms & Crio [#585](https://github.com/BoldGrid/boldgrid-theme-framework/issues/585)
* Bug Fix: Footer menu inherits site content link underline [#678](https://github.com/BoldGrid/boldgrid-theme-framework/issues/678)

### 2.14.0 ###
* New Feature: New container type - full width but contained [#540](https://github.com/BoldGrid/boldgrid-theme-framework/issues/540)
* New Feature: Extend new container type to headers & footers [#555](https://github.com/BoldGrid/boldgrid-theme-framework/issues/555)
* Bug Fix: hamburger menu icon shows next to menu from 1160px - 1199px [#366](https://github.com/BoldGrid/post-and-page-builder/issues/366)

### 2.13.3 ###
* Bug Fix: Re-build release with 2.13.1 & 2.13.2 fixes properly merged.

### 2.13.2 ###
* Bug Fix: Fonts in Customizer are misaligned from input [#646](https://github.com/BoldGrid/boldgrid-theme-framework/issues/646)

### 2.13.1 ###
* Bug Fix: Responsive Utilities from PPB are not respected in latest Crio version [#637](https://github.com/BoldGrid/boldgrid-theme-framework/issues/637)

### 2.13.0 ###
* New Feature: Add controls for submenu backround, link, and active link colors [#587](https://github.com/BoldGrid/boldgrid-theme-framework/issues/587)
* Feature Update: Update PPB and Crio Google Fonts [#276](https://github.com/BoldGrid/post-and-page-builder/issues/276)
* Bug Fix: Headings responsive typography controls buttons [#623](https://github.com/BoldGrid/boldgrid-theme-framework/issues/623)
### 2.12.0 ###
* New Feature: Hamburger Menus on Tablet / Desktop [#512](https://github.com/BoldGrid/boldgrid-theme-framework/issues/512)
* New Feature: Extend responsive text controls to Tagline & Custom Page Header Site Title [#557](https://github.com/BoldGrid/boldgrid-theme-framework/issues/557)
* New Feature: Select primary / secondary button design from Customizer [#507](https://github.com/BoldGrid/boldgrid-theme-framework/issues/507)
* New Feature: Make button text responsive [#556](https://github.com/BoldGrid/boldgrid-theme-framework/issues/556)
* New Feature: Font control for buttons [#506](https://github.com/BoldGrid/boldgrid-theme-framework/issues/506)
* Bug Fix: Custom Template 'Page Title' does not use calculated Heading Font Size values. [#553](https://github.com/BoldGrid/boldgrid-theme-framework/issues/553)
* Bug Fix: wp_register_style was called incorrectly [#595](https://github.com/BoldGrid/boldgrid-theme-framework/issues/595)
* Bug Fix: Custom Footers do not inherit main text setting from Customizer [#579](https://github.com/BoldGrid/boldgrid-theme-framework/issues/579)
* Bug Fix: Inconsistent hover effect on links [#513](https://github.com/BoldGrid/boldgrid-theme-framework/issues/513)
* Bug Fix: Sticky Headers & live preview [#564](https://github.com/BoldGrid/boldgrid-theme-framework/issues/564)
* Bug Fix: Edit buttons & Custom Footers [#571](https://github.com/BoldGrid/boldgrid-theme-framework/issues/571)
* Bug Fix: Fix hr alignment in custom footer templates [#578](https://github.com/BoldGrid/boldgrid-theme-framework/issues/578)
* Bug Fix: Remove min-height from small buttons [#577](https://github.com/BoldGrid/boldgrid-theme-framework/issues/577)
* Bug Fix: Hiding Page titles breaks title display in the Recent Post widget [#382](https://github.com/BoldGrid/boldgrid-theme-framework/issues/382)
* Bug Fix: Button color stays orange after changing palette [#561](https://github.com/BoldGrid/boldgrid-theme-framework/issues/561)

### 2.11.0 ###
* New Feature: Added responsive font size controls for Body Font, Headings and Site Title[#84](https://github.com/BoldGrid/boldgrid-theme-framework/issues/84)
* New Feature: Added support for new Sticky Header template and Footer Template features in Crio Pro 1.5.0[#544](https://github.com/BoldGrid/boldgrid-theme-framework/pull/544)

### 2.10.0 ###
* Bug Fix: Add Menu Link Hover Color Control in Crio [#328](https://github.com/BoldGrid/boldgrid-theme-framework/issues/328)
* Bug Fix: Explicit button height and nowrap makes buttons on mobile look bad [#475](https://github.com/BoldGrid/boldgrid-theme-framework/issues/475)
* Bug Fix: Improve button display in menus [#509](https://github.com/BoldGrid/boldgrid-theme-framework/issues/509)
* Bug Fix: Remove Text-Wrap from Headings [#508](https://github.com/BoldGrid/boldgrid-theme-framework/issues/508)
* Bug Fix: Cannot work with page title control from page unless Pro is active [#501](https://github.com/BoldGrid/boldgrid-theme-framework/issues/501)
* Bug Fix: Pagination padding and full-width margins creating horizontal scroll on mobile [#357](https://github.com/BoldGrid/boldgrid-theme-framework/issues/357)
* Bug Fix: Continued padding / margin fixes in Crio [#347](https://github.com/BoldGrid/boldgrid-theme-framework/issues/347)
* Bug Fix: Search result excerpt incldues the word Read... unlinked without space [#448](https://github.com/BoldGrid/boldgrid-theme-framework/issues/448)
* Bug Fix: Fix escaping in template file [105677](https://themes.trac.wordpress.org/ticket/105677)

### 2.9.4 ###
* Bug Fix: Fix fatal error with Font Awesome Plugin.

### 2.9.3 ###
* Bug Fix: Removed Font Awesome notice from the admin notices [#317](https://github.com/BoldGrid/boldgrid-theme-framework/issues/317)
* Bug Fix: Crio Pro Sticky Header Menu [#376](https://github.com/BoldGrid/boldgrid-theme-framework/issues/317)
* Bug Fix: Default menu locations not selectable after changing them in the customizer [#483](https://github.com/BoldGrid/boldgrid-theme-framework/issues/483)
* Improvement: Make embedded videos more responsive [#490](https://github.com/BoldGrid/boldgrid-theme-framework/issues/490)

### 2.9.2 ###
* Bug Fix: Footer Layout Delete Buttons are disabled in same row as Attribution [#478](https://github.com/BoldGrid/boldgrid-theme-framework/issues/478)

### 2.9.1 ###
* Bug Fix: Blog Page Read More Links - missing / broken controls [#480](https://github.com/BoldGrid/boldgrid-theme-framework/issues/480)

### 2.9.0 ###
* New Feature: New Edit Buttons added to Customizer Preview that feature dropdowns for buttons with multiple control options.
* Bug Fix: Crio - Branding in Footer - Site Title font bug [#431](https://github.com/BoldGrid/boldgrid-theme-framework/issues/431)
* Bug Fix: Crio Customizer Live Preview - font size / font weight does not update [#307](https://github.com/BoldGrid/boldgrid-theme-framework/issues/307)
* Bug Fix: Crio - Difficulty working with Widgets in the Customizer [#293](https://github.com/BoldGrid/boldgrid-theme-framework/issues/293)

### 2.8.2 ###
* Bug Fix: Crio - Venetian Inspiration (inspirations-theme-73) z-index issue with CTA button [#430](https://github.com/BoldGrid/boldgrid-theme-framework/issues/430)

### 2.8.1 ###
* Bug Fix: BoldGrid Attribution should not be toggleable without license [#189](https://github.com/BoldGrid/boldgrid-theme-framework/issues/189)
* Bug Fix: Crio Customizer Missing Sprout Invoice Icon [#270](https://github.com/BoldGrid/boldgrid-theme-framework/issues/270)
* Bug Fix: Excerpt Length controls in Design > Post List Settings [#358](https://github.com/BoldGrid/boldgrid-theme-framework/issues/358)
* Bug Fix: Active menu item on blog posts - Inspirations [#348](https://github.com/BoldGrid/boldgrid-theme-framework/issues/348)
* Bug Fix: Site Background Opacity only shows with Customizer open [#281](https://github.com/BoldGrid/boldgrid-theme-framework/issues/281)
* Bug Fix: Links - Hover Color Brightness does not show in live preview [#257](https://github.com/BoldGrid/boldgrid-theme-framework/issues/257)
* Bug Fix: Change background image implementation [#189](https://github.com/BoldGrid/boldgrid-theme-framework/issues/350)
* Bug Fix: Control for Box Shadow Inset / Outset - clicking actual toggle doesn't work [#255](https://github.com/BoldGrid/boldgrid-theme-framework/issues/255)
* Update: Improve Attribution display [#311](https://github.com/BoldGrid/boldgrid-theme-framework/issues/311)
* Update: Transparent Widget Background [#280](https://github.com/BoldGrid/boldgrid-theme-framework/issues/280)
* Update: Update Customizer Styling to be compatible with upcoming WordPress 5.8 Release
* Update: Opted-out of customizer's Gutenberg Widget Editor for upcoming WordPress 5.8 Release
### 2.8.0 ###
* New Feature: Added 'Related Controls' feature to customizer.
* Update: Re-arranged / consolidated some typography controls.
* Update: Renamed 'Colors' section to 'Color Palettes'
* Update: Updated some deprecated jQuery.

### 2.7.1 ###
* Bug Fix: Crio Custom Header Glitches [#368](https://github.com/BoldGrid/boldgrid-theme-framework/issues/368)
* Update: Theme Check fixes made to column width controls.

### 2.7.0 ###
* New Feature: Header layout presets.
* New Feature: Partial Refresh enabled for more header elements in customizer.
* New Feature: Replaced Column Width controls with new multi-sliders.
* Note: Skipped 2.6.0 for more consistent versioning with BGTFW & Crio releases.

### 2.5.2 ###
Bug Fix: Crio - Nested Row [#343](https://github.com/BoldGrid/boldgrid-theme-framework/issues/343)
Update: Added CSS styles for WedgeV2 update.

### 2.5.1 ###
Bug Fix: Full width menu background doesn't touch sides [#327] (https://github.com/BoldGrid/boldgrid-theme-framework/issues/327)
Bug Fix: Widget in full width header = horizontal scrollbar [#244] (https://github.com/BoldGrid/boldgrid-theme-framework/issues/244)
Bug Fix: Full width sidebar background doesn't hit sides on mobile [#229] (https://github.com/BoldGrid/boldgrid-theme-framework/issues/229)

### 2.5.0 ###
* New Feature: Added a 'Crio' top level menu page, moved the welcome page there, and added a 'Get Pro' page to highlight new premium features.
* Update: [Snyk] Upgrade @wordpress/hooks from 2.8.0 to 2.10.0 [#305](https://github.com/BoldGrid/boldgrid-theme-framework/pull/305)
* Update: [Snyk] Upgrade jarallax from 1.12.1 to 1.12.4 [#304](https://github.com/BoldGrid/boldgrid-theme-framework/pull/304)
* Update: [Snyk] Upgrade @wordpress/dom-ready from 2.9.0 to 2.11.0 [#303](https://github.com/BoldGrid/boldgrid-theme-framework/pull/303)
* Update: [Snyk] Upgrade @babel/runtime-corejs2 from 7.9.6 to 7.12.1 [#302](https://github.com/BoldGrid/boldgrid-theme-framework/pull/302)
* Update: [Snyk] Fix for 2 vulnerabilities [#209](https://github.com/BoldGrid/boldgrid-theme-framework/pull/209)

### 2.4.0 ###
* New Feature: Added functionality for Crio Premium's Page Header Templates.

### 2.2.3 ###
* Bug Fix: Crio 2.3.2 & PPB 1.13.3 - Main Text font doesn't pull thru to Editor [#272](https://github.com/BoldGrid/boldgrid-theme-framework/issues/272)
* Bug Fix: Some fonts don't show their name in the font selection dropdown [#264](https://github.com/BoldGrid/boldgrid-theme-framework/issues/264)
* Bug Fix: Restoring a backup loses the stylesheet (all styling) [#278](https://github.com/BoldGrid/boldgrid-theme-framework/issues/278)

### 2.2.2 ###
* Update: Updated Kirki-Framework to latest stable version.
* Update: Updated Google Fonts Sprites and webfonts.json
* Update: Updated typography to work with new version of Kirki Framework
* Update: Updated to work on WP 5.5+

### 2.2.1 ###
* Bug Fix: Moved Header Background Color control to the Design -> Header -> Background section
* Bug fix: Full Width sections do not span the entire header [#232](https://github.com/BoldGrid/boldgrid-theme-framework/issues/232)
* Bug fix: Fixed Background Image doesn't work [#193](https://github.com/BoldGrid/boldgrid-theme-framework/issues/193)
* Bug fix: Incorrect body text color when setting background image effect to "Parallax" [#220](https://github.com/BoldGrid/boldgrid-theme-framework/issues/220)
* Bug fix: Header overlay control should be conditionally visible [#89](https://github.com/BoldGrid/boldgrid-theme-framework/issues/89)

### 2.2.0 ###
* New Feature: Added Control to change the number of products shown per page on shop catalog [#210](https://github.com/BoldGrid/boldgrid-theme-framework/issues/210)
* New Feature: Added Featured Image Control to single blog posts [#192](https://github.com/BoldGrid/boldgrid-theme-framework/issues/192)
* Bug fix: WooCommerce Container control appears w/o WooCommerce installed [#216](https://github.com/BoldGrid/boldgrid-theme-framework/issues/216)
* Bug fix: Custom Theme JS incorrectly escaping single and double quotes [#199](https://github.com/BoldGrid/boldgrid-theme-framework/issues/199)
* Update: Updated build dependancy sass.js from 0.9.13 to 0.11.1 [#196](https://github.com/BoldGrid/boldgrid-theme-framework/pull/196)
* Update: Updated build dependancy css-var-ponyfill from 1.11.1 to 1.17.2 [#195](https://github.com/BoldGrid/boldgrid-theme-framework/pull/195)
* Update: Updated build dependacy @bable/runtime-corejs2 from 7.4.4 to 7.9.6 [#194](https://github.com/BoldGrid/boldgrid-theme-framework/pull/194)

### 2.1.18 ###
* Bug fix: Store Notice should be at top of page [#39](https://github.com/BoldGrid/boldgrid-theme-framework/issues/39)
* Bug fix: Required fields in checkout missing asterisk [#37](https://github.com/BoldGrid/boldgrid-theme-framework/issues/37)
* Update: Added container control for WooCommerce Pages [#30](https://github.com/BoldGrid/boldgrid-theme-framework/issues/30)
* Update: Added WooCommerce icon for customizer menu [#67](https://github.com/BoldGrid/boldgrid-theme-framework/issues/67)

### 2.1.17 ###
* Bug fix: Corrected display of attribution controls when used with Inspirations [#187](https://github.com/BoldGrid/boldgrid-theme-framework/pull/187)
* Update: Adding host_attribution footer control.

### 2.1.16 ###
* Update: Updated WooCommerce Templates.
* Bug fix: Sub-menus not displaying in preview after making changes to header in customizer [#26](https://github.com/BoldGrid/boldgrid-theme-framework/issues/26)
* Bug fix: Attribution links not displaying properly on mobile devices [#177](https://github.com/BoldGrid/boldgrid-theme-framework/issues/177)
* Bug fix: Colorpalette click event listener triggering on all sections clicks [#23](https://github.com/BoldGrid/boldgrid-theme-framework/issues/23)
* Bug fix: Column / Row flexbox issues on Safari [#25](https://github.com/BoldGrid/boldgrid-theme-framework/issues/25)
* Bug fix: widget partial refresh causes background image tabs to display all options [#156](https://github.com/BoldGrid/boldgrid-theme-framework/issues/156)
* Bug fix: Second header menu dropdown overlaps text link on mobile [#150](https://github.com/BoldGrid/boldgrid-theme-framework/issues/150)
* Bug fix: WP Editor text-contrast issues in dark palette [#40](https://github.com/BoldGrid/boldgrid-theme-framework/issues/40)
* Bug fix: Class 'Boldgrid_Framework_Activate' does not have a method 'reset' [#173](https://github.com/BoldGrid/boldgrid-theme-framework/issues/173)
* Bug fix: Crio Full Width Footer = Horizontal Scrollbar [#149](https://github.com/BoldGrid/boldgrid-theme-framework/issues/149)
* Bug fix: Video Header with Sticky Header has wrong background color [#164](https://github.com/BoldGrid/boldgrid-theme-framework/issues/164)
* Bug fix: Clicking the Home icon in breadcrumb trail hangs for 5-7 seconds in customizer panels/sections [#27](https://github.com/BoldGrid/boldgrid-theme-framework/issues/27)
* Bug fix: Form styling from wp.org theme preview incomplete [#152](https://github.com/BoldGrid/boldgrid-theme-framework/issues/152)
* Bug fix: header/footer widgets inheriting bootstrap body font [#28](https://github.com/BoldGrid/boldgrid-theme-framework/issues/28)
* Bug fix: Previewing bgtfw based themes fails to load google fonts [#155](https://github.com/BoldGrid/boldgrid-theme-framework/issues/155)

### 2.1.15 ###
* Bug fix: Directional controls not saving css output correctly.

### 2.1.14 ###
* Bug fix: Reset password field not visible.

### 2.1.13 ###
* Bug fix: Reset row margins to bootstrap defaults, fixes column widths.

### 2.1.12 ###
* Bug fix: `mce_external_plugins` returning incorrect values. [#129](https://github.com/BoldGrid/boldgrid-theme-framework/issues/129)
* Bug fix: WP 5.3 - Color palette preview fails with js error. [#132](https://github.com/BoldGrid/boldgrid-theme-framework/issues/132)
* Bug fix: Background patterns not displayed if background image is set. [#135](https://github.com/BoldGrid/boldgrid-theme-framework/issues/135)
* Bug fix: Preview of header background videos not displaying. [#138](https://github.com/BoldGrid/boldgrid-theme-framework/issues/138)
* Bug fix: Body background overlay not working if pattern was selected before setting image. [#139](https://github.com/BoldGrid/boldgrid-theme-framework/issues/139)
* Bug fix: Variable styles not applied for when used within Post and Page Builder. [#141](https://github.com/BoldGrid/boldgrid-theme-framework/issues/141)
* Bug fix: Background image setting switches to pattern & color after adding image. [#140](https://github.com/BoldGrid/boldgrid-theme-framework/issues/140)
* Update: Font sprite and webfonts json were updated to match latest font availability. [#134](https://github.com/BoldGrid/boldgrid-theme-framework/issues/134)

### 2.1.11 ###
* Bug fix: Ensure that the site header is correctly output when settings are updated in customizer. [#127](https://github.com/BoldGrid/boldgrid-theme-framework/issues/127)
* Update: Changed upsell link in customizer. [#126](https://github.com/BoldGrid/boldgrid-theme-framework/issues/126)

### 2.1.10 ###
* Bug fix: Comment titles on post/pages should not be hidden when post titles are hidden in customizer. [#123](https://github.com/BoldGrid/boldgrid-theme-framework/issues/123)
* Bug fix: Creating new menu in customizer should show only used menu locations. [#124](https://github.com/BoldGrid/boldgrid-theme-framework/issues/124)
* Bug fix: Allow fonts to display in Gutenberg and Classic Editor for proper WYSIWYG. [#125](https://github.com/BoldGrid/boldgrid-theme-framework/issues/125)

### 2.1.9 ###
* Bug fix: Menu items with mark now respect whitespace. [#114](https://github.com/BoldGrid/boldgrid-theme-framework/issues/114)
* Bug fix: The "No Sidebar" icon is used for customizer controls instead of default "Sidebar Right". [#116](https://github.com/BoldGrid/boldgrid-theme-framework/issues/116)
* Bug fix: Primary sidebar now loads in the Widgets section in customizer. [#118](https://github.com/BoldGrid/boldgrid-theme-framework/issues/118)
* Bug fix: Sidebar icon is now properly positioned. [#119](https://github.com/BoldGrid/boldgrid-theme-framework/issues/119)
* Bug fix: Section title fonts in customizer are now correct. [#120](https://github.com/BoldGrid/boldgrid-theme-framework/issues/120)
* Update: Removed unnecessary loading of FontAwesome from CDN in Kirki. [#113](https://github.com/BoldGrid/boldgrid-theme-framework/issues/113)
* Update: The default for post dates has been set to date format instead of human readable. [#115](https://github.com/BoldGrid/boldgrid-theme-framework/issues/115)
* Update: Removed Crio branding from customizer controls. [#117](https://github.com/BoldGrid/boldgrid-theme-framework/issues/117)

### 2.1.8 ###
* Update: Minor changes for WPTRT WordPress.org submission.

### 2.1.7 ###
* Bug fix: Pagination "active" class is now properly applied. [#109](https://github.com/BoldGrid/boldgrid-theme-framework/issues/109)
* Bug fix: Removed duplicate panel being displayed in Gutenberg Editor. [#108](https://github.com/BoldGrid/boldgrid-theme-framework/issues/108)
* Bug fix: Ignored CSS transitions on archive pages when printing. [#106](https://github.com/BoldGrid/boldgrid-theme-framework/issues/106)
* Update: Increased tap target size for pagination. [#105](https://github.com/BoldGrid/boldgrid-theme-framework/issues/105)

### 2.1.6 ###
* Update: Ensure `paginate_comments_links` is being used where necessary. [#92](https://github.com/BoldGrid/boldgrid-theme-framework/issues/92)
* Update: scssphp package updated to address Theme Check issue.

### 2.1.5 ###
* Bug fix: Fixed issue where sidebars were not dynamically populating in customizer. [#47](https://github.com/BoldGrid/boldgrid-theme-framework/issues/47)
* Bug fix: WP5.2 unitless line-height causing alignment issues for icons in customizer. [#88](https://github.com/BoldGrid/boldgrid-theme-framework/issues/88)
* Bug fix: WooCommerce quantity inputs no longer disabled after ajax cart updates. [#34](https://github.com/BoldGrid/boldgrid-theme-framework/issues/34)
* Bug fix: Fixed partial refresh issue with changing header layouts. [#91](https://github.com/BoldGrid/boldgrid-theme-framework/issues/91)

### 2.1.4 ###
* New Feature: Users can now toggle on/off the "Scroll To Top" button from the customizer. [#78](https://github.com/BoldGrid/boldgrid-theme-framework/issues/78), [#79](https://github.com/BoldGrid/boldgrid-theme-framework/issues/79)
* New Feature: Users can now select different background blend modes for background image overlays in the customizer. [#85](https://github.com/BoldGrid/boldgrid-theme-framework/issues/85)
* Bugfix: Southwest alignment control for branding blocks should now be correctly aligned. [#80](https://github.com/BoldGrid/boldgrid-theme-framework/issues/80)
* Bugfix: Pagination elipses should no longer have hover effects applied. [#77](https://github.com/BoldGrid/boldgrid-theme-framework/issues/77)
* Bugfix: Parallax backgrounds should show up on the frontend site now. [#81](https://github.com/BoldGrid/boldgrid-theme-framework/issues/81)
* Bugfix: Parallax backgrounds should now fill entire screen in customizer. [#82](https://github.com/BoldGrid/boldgrid-theme-framework/issues/82)
* Bugfix: Fixed some issues for select elements not displaying with the correct styles on the frontend site.
* Update: Raised minimum PHP version to 5.6.0.
* Update: Updated scssphp dep to latest version.
* Update: Removed jQuery Stellar library and added Jarallax for a smoother parallax effect and better performance.
* Update: Removed limitation of node 10.12.0 - 10.13.0 for build process. [#86](https://github.com/BoldGrid/boldgrid-theme-framework/pull/86)
* Update: Added support for WooCommerce's upcoming new hooks: `woocommerce_before_quantity_input_field`, and `woocommerce_after_quantity_input_field`.
* Update: Added `.form-control` and `.input-number` CSS classes to quantity inputs via `woocommerce_quantity_input_classes`.

### 2.1.3 ###
* Bugfix: Fixed issue with dynamic imports resolving to incorrect paths.
* Update: Removed `wp_deregister_style` and `wp_deregister_script` calls for selectWoo.

### 2.1.2 ###
* Bugfix: Added starter content's customizer query for blog posts.
* Bugfix: Removed closing div for widget areas in customizer.
* Update: Removed source maps for production build.

### 2.1.1 ###
* Bugfix: Addressed various output escaping issues.
* Update: Moved translation support from bgtfw to themes.
* New Feature: Added new background patterns for customizer.
* New Feature: Added styles for Gutenberg buttons.
* Update: Removed NinjaForms bootstrap.css overrides.
* Update: Switched to MIT licensed animation library, everything works as it did before, including other plugins hooked in.
* Update: Updated license to GPL-3.0-or-later.
* Update: Removed starter content overrides that aren't allowed in WordPress.org.
* Update: Replaced all non-GPL-2.0-or-later compatible images.

### 2.1.0 ###
* Bug fix: Remove font preview in MS edge, helps with performance

### 2.1.0-rc.2 ###
* New Feature: Section links added to customizer for Header/Footer layouts.
* Update: Removed composer installation from bgtfw for libraries only used by themes.
* Update: WooCommerce compatibility for v3.
* Bug fix: Dynamic content areas should wrap rows when more than 6 items are added.
* Bug fix: Custom logo control in dynamic layouts is not being hidden.
* Bug fix: Sticky Header not being initialized correctly when toggling options in customizer.
* Bug fix: Unable to add new section if no sections present in dynamic layouts.
* Bug fix: Titlecase BoldGrid and WordPress in attribution controls.
* Bug fix: Italic fonts on main typography control overrides menus and widgets fonts.
* Bug fix: Tagline needs bottom margin.
* Bug fix: Blog page featured images have auto width applied.
* Bug fix: Editor not aligning column content in center.
* Bug fix: Undefined index for bgtfw configs generated from BoldGrid Inspirations Premium due to removed config.
* Bug fix: 404 page containers conflict with container controls.
* Bug fix: Add spacing below Post Navigation.
* Bug fix: Featured Images aren't able to be hidden on blog page.
* Bug fix: Removed hardcoded language strings from JS for widget highlight in customizer for proper translations.

### 2.1.0-rc.1 ###
* Update: Added tabs for dynamic header layout, sticky vs standard.
* Update: Allow sticky navigation to have it's own nav locations set.
* Update: Moved sticky controls out of standard dynamic header layout controls.
* Update: Menus and sidebar location sections are now dynamic based on dynamic controls.
* Update: Adding Crio Enzo as icon for admin menu.

### 2.1.0-alpha.1 ###
* New Feature: Adding dynamic layout controls for header/footer.
* New Feature: Added base form support with a new style.
* Bug fix: Fixed scrolling issues on IE, Safari, and FF in customizer.
* Update: Removed controls for enable footer, header/footer containers.
* Update: Change radio select controls for header position to buttonset with icons.

### 2.0.0 ###
* New Feature: Layout Selection - Allow users to select between a full width content area or fixed width within the Customizer.
* New Feature: Header and Footer Layouts - Multiple header and footer styles, which can be selected from within the Customizer.
* New Feature: Background Video Support - Homepage background video for your header from Youtube or Vimeo.
* New Feature: Dynamic Content Layout Support - Allow users to select between multiple different blog styles, and change elements such as title, metadata and the overall look and feel with much more precision than ever before.
* New Feature: Improved Font Controls - Users now have much more control over the fonts elements independently, allowing granular control of the typography.
* New Feature: Improved Color Controls - Users have much more control over the colors individual elements use, to allow for greater customization of their website's look and feel.

### 1.5.10 ###
* Update: Removed reference from bootstrap css to glyphicons since they are unused in bgtfw.

### 1.5.9 ###
* Update: Removing the spinner's arrows from the quantity number inputs.

### 1.5.8 ###
* Update: Added styles for 3.4.0 WooCommerce changes.

### 1.5.7 ###
* Update: Updating WooCommerce templates to latest stable version.

### 1.5.6 ###
* Bug fix: Fixing issue with .site-title line-height conflict from WP4.7 changes.

### 1.5.5 ###
* Update: Change Post and Page Builder url.

### 1.5.4 ###
* Update: Updating version of kirki.

### 1.5.3 ###
* Update: Updating components.

### 1.5.2 ###
* New Feature: Moving component library into it's own package.

### 1.5.1 ###
* Update: Moving sidebar widget area into configuration file.
* Update: Provide support for buttons as post navigation.

### 1.5 ###
* Update: Bump version.

### 1.4.8 ###
* Bug fix: Fixing button font sizes.
* Bug fix: Append tinymce customizer typography styles instead of prepending.
* Update: Updating versions on CSS files.

### 1.4.7 ###
* Bug fix: Adding theme's defined palette class to TinyMCE Editor instances.

### 1.4.6 ###
* Update: Updating component shapes to match image styles.
* Update: Loading sticky header JS for mobile.

### 1.4.5 ###
* Update: Changed the default fieldset legend styles added.
* Update: Adding new styles to the default components.

### 1.4.4 ###
* Bug fix: Fixed help overlay section in customizer so it's part of the actual controls.
* Bug fix: Fixed cases where FS_CHMOD_DIR is an undefined constant with $wp_filesystem.

### 1.4.3 ###
* Update: Link focus should be dynamically found for hide_ links.

### 1.4.2 ###
* Bug fix: Check if template configs are present.
* Update: Default menu descriptions are now generic instead of contextual.

### 1.4.1 ###
* Update: Let sidebar search widget have standard appearance on small devices.
* Bug fix: Fixing issues with wooCommerce ratings and extraneous div outputting.
* Bug fix: Customizer tablet preview not showing tablet size menu.
* Update: Add default button styles for wooCommerce support.

### 1.4.0.1 ###
* Bug fix: Adjusting line-height for tinymce editor for WordPress 4.8 changes.

### 1.4 ###
* Bug fix: CTA widget inherits well class if user tries to re-add it.
* Bug fix: Added default styles for sidebar search form widgets.

### 1.3.9 ###
* Bug fix: Fixing error when running wp-cli commands.

### 1.3.8 ###
* Update: Set the editor content area to the max width from the theme.
* Bug fix: Customizer edit button for edit this page goes to wrong URL.
* Bug fix: Staging theme mods being transfered across themes.
* Bug fix: Issues compiling colors on upgrade from old themes.
* Update: Removing CTA checks from framework.

### 1.3.7 ###
* Update: Attribution links are now using postMessage to avoid customizer refreshes.
* New Feature: Custom Modernizr builds are now added to theme framework.
* Update: Sticky Footer is now handled with flexbox if browser supports it.
* Bug fix: Added markup for password required pages and posts inside sections/containers.
* New Feature: Adding body class for disabled bstw state.
* Update: Margin applied to contact blocks for better spacing in bgtfw.

### 1.3.6 ###
* Bug fix: Adding .page-template-default to editor if default template is in use.

### 1.3.5 ###
* Update: Allow widget data to be filtered before widgets are created.
* Bug fix: weibo icon.

### 1.3.4 ###
* Update: Setting JS compiler instance limit to 50 to accommodate larger sass sheets.
* Bug fix: Aligning post navigation links to left and right for older vs newer.
* Update: Adding padding to search results.

### 1.3.3 ###
* Bug fix: Merging standard and minified js files.

### 1.3.2 ###
* Bug fix: Hide inline link editor when closing black-studio panel.
* Bug fix: Load theme styles only for pages and posts.
* Update: Open social media icons in new tab.

### 1.3.1 ###
* Update: Changing post navigation links from H1s to H2s.
* Update: Changing format of boldgrid_menus_created option.
* Update: Using meaningful keys in boldgrid_widgets_created option.
* Bug fix: Fixing issue with bad data in boldgrid_widgets_created.

### 1.3.0.2 ###
* Bug fix: Customizer edit buttons not appearing for menus.
* Bug fix: Edit buttons appearing when not in Customizer.

### 1.3.0.1 ###
* Update: Removing custom CSS panel added in WordPress 4.7 Core update.
* Update: Removing visible edit buttons added in WordPress 4.7 Core update.
* Bug fix: Fixing issue causing fatal Javascript issues in background controls after 4.7 Core update.
* Bug fix: Fixing issue with stacked display controls in background section, 4.7.
* Bug fix: Fixed issue where help text in menu and widget customizer not visible 4.7.
* Bug fix: Fixed errors when viewing a changeset id on the front end: 4.7.

### 1.3 ###
* Update: Prevent Buttons from wrapping.

### 1.2.11 ###
* Update: Added neutral color color classes.

### 1.2.10 ###
* Update: Boldgrid sections now have a min-height of 30px inside site content.
* Update: When Home template is used, update disabled page title tooltip message.

### 1.2.9 ###
* Bug fix: Fixing issue compiling staging colors.

### 1.2.8 ###
* Update: Adding additional text contrast classes.
* Bug fix: Check colors are enabled and default palette exists before attempting to set palette.
* Bug Fix: Home page title causes duplicate H1 tags.
* Bug Fix: Enqueue staging buttons and staging colors to the editor control system.

### 1.2.7 ###
* Update: Framework now handles filtering for full width pages.
* Bug Fix: Fixing issue with tinymce cache busting.
* Bug Fix: Blog page not getting proper containers if set to a static page.

### 1.2.6 ###
* Bug Fix: Fixing issue with sidebar displaying on specific page templates.

### 1.2.5 ###

* Bug Fix: Fixing issue were suggested palettes did not respect the locked color.
* Bug Fix: Sidebar widgets should have h2 tags for titles instead of h1.
* Bug Fix: Removed Bootstrap button classes from theme buttons.
* Update: Removed staging from recommended plugin install list.
* New Feature: Added config for BGTFW Version.
* Update: If any colors aren't found before compile, don't attempt to compile the scss.
* Bug Fix: Attachment pages need container classes.
* Update: Only recommending plugins, and updating verbiage to reflect that.

### 1.2.4 ###
* Bug Fix: Fixing issue causing masonry galleries to not display.
* Bug Fix: Allow page templates to define the <main> element's container classes.
* Bug Fix: Add font family classes to framework.
* Bug Fix: Check if function exists before display_sidebar fires.
* New Feature: Allow all WordPress conditionals to be used in display_sidebar.
* Update: No longer renaming Widgets to Header/Footer Widgets in the customizer.
* Bug Fix: Default h1 and h3 font sizes not rendering correctly (not in use on current themes).
* New Feature: Adding buttons library for editor.
* Bug Fix: TinyMCE triggered by a Ninja Forms hook while editing a form.

### 1.2.3 ###
* New Feature: Added SnapChat social media icons.
* Update: Added some default styles to BGTFW components.
* Bug Fix: Addressed jQuery Migrate deprecated notice for .load() in edit buttons.
* Bug Fix: Add blog container class if user sets front page to display their blog posts.
* New Feature: Allow theme activation to trigger recommended/required plugins.
* Bug Fix: Palettes with two of same color didn't get unique color class assigned.
* Bug Fix: Custom classes push via configs to tagline weren't applied for live preview in customizer.
* Bug Fix: Apply comment submit classes via PHP instead of jQuery.
* Update: Sass.js updated to v0.9.12.
* Bug Fix: Some themes don't have an edit button for footer attribution links.
* Bug Fix: Let attribution links bounce on focus with customizer edit buttons.

### 1.2.2 ###
* Bug Fix: Background size not being applied to parallax backgrounds.

### 1.2.1 ###
* Update: Updating color palettes tutorial link.
* Bug Fix: Updating the load order of styles into the editor.

### 1.2 ###
* New Feature: Add tutorials link to each section in the menus panel.
* New Feature: Adding container configuration classes.
* Update: Font Awesome updated to 4.6.3.
* Bug Fix: Fixing issue with typography controls 4.4 compatibility.
* Bug Fix: Fixing 4.6 bug causing background image previews to not display.
* Bug Fix: Hiding generic locations that are not in use.
* Bug Fix: Customizer dialog inheriting styles with undesired effects.
* Bug Fix: Stop Wordpress from assigning widgets to our areas on theme switch.
* Bug Fix: Edit buttons display primary menu background even if no menu is present.

### 1.1.9 ###
* Bug Fix: Typography - additional selectors should be read for showing/hiding menu item.
* Bug Fix: Typography - headings/subheadings from configs override each other.

### 1.1.8 ###
* Bug Fix: Edit buttons no longer pull in color from themes.
* Bug Fix: Typography in the editor is no longer prefixed with .mce-content-body.
* Bug Fix: Removed php closing tag from category.config.php.

### 1.1.7 ###
* Update: Added helper method for Inspirations category lookups.
* Bug Fix: On theme activation set default color palette theme_mod.
* New Feature: Colors in the active palette now have animations to upon focusing the control.
* Bug Fix: Staging theme updates reset color palettes.

### 1.1.6 ###
* New Feature: Updated drag behavior to swap colors.
* New Feature: The neutral color of a palette can now be modified with drag and drop.
* New Feature: The UI of color palettes has been improved.
* New Feature: Colors within a users color palette can now be selected from the color picker.
* New Feature: Improved color palette suggestion algorithms.
* New Feature: Enabling customizer edit buttons.
* Bug Fix: Removed duplicate entries of color palettes from saved palettes.

### 1.1.5.1 ###
* Bug Fix: Enable footer switch not fully triggering.

### 1.1.5 ###
* Update: Kirki from v2.1.0.1 to v2.3.2.
* Update: Changed customizer tablet view width to 768px.
* New Feature: Added slim scrollbar support via configs.
* New Feature: Added scroll to top support via configs.
* New Feature: Added support for additional font relationships via configs.
* New Feature: Allow child theme to auto-enqueue it's own js file.
* New Feature: Updated wow.js to support framework configs.
* New Feature: Added blockquote calculations to Main Text font sizes.
* Bug Fix: Headings Text Transform property not saving.

### 1.1.4.1 ###
* Bug Fix: Issue causing Visual Editor widget areas to fail on firefox.

### 1.1.4 ###
* Bug Fix: Issue causing color palette customizer to fail on child themes.
* New Feature: The frameworks root path can now be overwritten with BGTFW_PATH constant.
* New Feature: Text shadow controls are now postMessage.
* New Feature: Tagline will now inherit margin controls from site title.
* Update: Customizer edit buttons now using pencil icon.

### 1.1.3 ###
* Bug fix: Addressed issue where subheadings weren't having font-family property set.
* Bug fix: Inline Links in Visual Editor in Customizer now are working for WP 4.5+.
* Misc: Bootstrap-compile now works with SCRIPT_DEBUG set to true.
* New Feature: Child theme's will transfer menus from parent on activation.

### 1.1.2 ###
* Hotfix: Disable responsive device previews, and use WP's new responsive previews in WP 4.5+.

### 1.1.1 ###
* New Feature: Child themes can now be created and work properly.
* Misc: Replaced Underscore's accessibility classes with Bootstrap's.
* New Feature: Added support for using heading classes that work with typography controls.
* Misc: Code refactor of activate class.
* Misc: Added CodeClimate Configuration.

### 1.1 ###
* Bug fix: Animate.css now can load properly.
* Bug fix: Allow child themes to use their own background images.
* Misc: Updated scssphp dependency to v.0.6.1.
* New Feature: Typography controls now have image previews.
* Bug fix: Unique menu names not formatted correctly.
* Bug fix: On start over, staging menus are not deleted.
* Bug fix: Search results hiding page titles unintentionally.
* Misc: Setting default style of menus as inline.

### 1.0.10 ###
* Update: Changing email links to @example.com.
* Update: Reorganized advanced footer panel.
* Update: Added alt-font to tagline and widgets, and change section title.
* Fix: Correcting issues with sticky footer.

### 1.0.9.2 ###
* Fix: Color palettes not working on staging sites.

### 1.0.9.1 ###
* Fix: Attribution links unintentionally hidden from footer.
* Fix: zIndex issues with magnified files.

### 1.0.9 ###
* Fix: Preventing titles for showing up when menu title is markup.

### 1.0.8.3 ###
* Update: Moved repo to github.

### 1.0.8.2 ###
* Fix: Updating Kirki to 2.0.9

### 1.0.8.1 ###
* Fix: Fixing Issue with toggling controls

### 1.0.8 ###
* Fix:Enable page title toggle on new pages
* Update: Update kirki to v2.0.3
* Update: Updating PHP Sass compiler
* Update: Updating JS Sass compiler
* Fix: Fixing conflict with other plugins that include our PHP compilers

### 1.0.7.1 ###
* New Feature: Adding a page title toggle

### 1.0.7 ###
* Fix: Correcting issues with colors in site previews

### 1.0.6 ###
* New feature: Adding a method to add incline styles to the editor plugins
* Fix: Fixing Style issues in the customizer overlay

### 1.0.5.1 ###
* Bug Fix: Fixing issue with sticky Footer in middle of page
* Bug Fix: Fixed Post page with comments markup issue

### 1.0.5 ###
* New feature: Save menus created by framework in an option.
* Bug Fix: Upon deploying staging, new active site lost Social Media icons.

### 1.0.4 ###
* Bug Fix: Fixed Typos in Advanced Header/Footer Sections
* New feature: Adding readme.txt file

### 1.0.3 ###
* Bug Fix: Fixing issues with special thanks links
* New feature: Added sticky footer options
